#ifndef OClumpModifier_H__
#define OClumpModifier_H__

enum
{
	// Dynamic attributes defined on enum class PlugId
	clump_PLUGS = 1000,
	
	//////////////////////////////////////////////////////////////////////////
	// Object attributes -- DO NOT CHANGE ORDER, attribute keys on saved projects
	clump_START = 2000,
	
	clump_StrandGroupAttribute,
	clump_RandomSeedAttribute,
	clump_AmountAttribute,
	clump_AmountCurveAttribute,
	clump_AmountMultiplierAttribute,
	clump_AmountChannelAttribute,
	clump_PreserveStrandLengthsAttribute,
	clump_AttractToClosestStemPointAttribute,
	clump_RootBlendingPositionAttribute,
	clump_RoundClumpsAttribute,
	clump_TwistAttribute,
	clump_TwistCurveAttribute,
	clump_TwistMultiplierAttribute,
	clump_TwistChannelAttribute,
	clump_FlyawayFractionAttribute,
	clump_FlyawayAmountAttribute,
	clump_SetClumpSizeAttribute,
	clump_ClumpSizeAttribute,
	clump_ClumpSizeCurveAttribute,
	clump_RegionMultiplierAttribute,
	clump_RegionChannelAttribute,
	clump_AddClumpIndexChannelAttribute,
	clump_RegionClumpCandidatesAttribute,
	
	clump_ClumpEditMode,
	clump_SelectToolRadius,
	clump_SubSelectionCount,

	clump_UseUvSpaceAttribute,
	clump_UvChannelIndexAttribute,
	clump_RespectHairPartsAttribute,
	clump_ClumpPatternRotationAttribute,
	clump_RegionDifferenceThresholdAttribute,
	
	
	// Clumps
	
	clump_Clumps_Group = 2200,
	
	clump_ClumpGenerationMethodAttribute,
	clump_ClumpCountAttribute,
	clump_ExternalClumpStrandsAttribute,

	// Global Clump Attributes
	
	clump_ClumpPatterns_Group = 2250,
	clump_PatternsAttribute,						// Braids list
	clump_PatternIndicesAttribute,					// generated from Braids list
	
	// Per Clump Attributes (GUI)
	
	clump_PerClump_Group = 2300,
	clump_AmountOverrideAttribute,
	clump_ClumpAmountCurveOverrideAttribute,
	clump_TwistOverrideAttribute,
	clump_ClumpTwistCurveOverrideAttribute,
	clump_PatternIndicesOverrideAttribute,

	// Per Clump Parameters (Clumper::Parameter)
	
	clump_PerClumpIndicesAttribute = 2400,			// affected clump indices
	clump_PerClumpAmountsAttribute,					// value
	clump_ClumpAmountCurveKnotCountsAttribute,		// curve points
	clump_ClumpValueCurvesPositionsAttribute,		// curve data
	clump_ClumpValueCurvesValuesAttribute,			// curve data
	clump_ClumpValueCurvesInterpolationsAttribute,	// curve data
	clump_PerClumpTwistsAttribute,					// value
	clump_ClumpTwistCurveKnotCountsAttribute,		// curve points
	clump_ClumpTwistCurvesPositionsAttribute,		// curve data
	clump_ClumpTwistCurvesValuesAttribute,			// curve data
	clump_ClumpTwistCurvesInterpolationsAttribute,	// curve data
	clump_PerClumpPatternIndicesAttribute,

	// Arrays
	
	clump_ClumpBarycentricCoordinatesAttribute = 2500,
	clump_ClumpFaceIndicesAttribute,
	clump_RootBarycentricCoordinatesAttribute,
	clump_RootFaceIndicesAttribute,
	clump_RootClosestClumpIndicesAttribute,
	clump_ClumpHairSelectionAttribute,
	clump_ClumpSelectionAttribute,


	//-------------------------------
	// Buttons and labels
	// do not add attributes that store data here
	
	clump_Button_CreateClumps = 3000,
	clump_Button_DeleteClumps,
	clump_Button_ResetClumps,
	
	clump_Button_ClumpHairEditing,
	clump_Button_ClumpEditing,

	clump_Button_SelectStrandsTool,
	clump_Button_SelectStrandsRectTool,
	clump_Button_SelectStrandsAll,
	clump_Button_SelectStrandsNone,

	clump_SubClumping_Group,
	clump_ClumpGuideBaseStrandIdsAttribute,
	clump_ClumpCenterBaseStrandIdsAttribute,
	clump_ClumpCenterGuideIdsAttribute,

	//////////////////////////////////////////////////////////////////////////
	
	clump_END
};

enum
{
	clump_ClumpGenerationMethod_Random,
	clump_ClumpGenerationMethod_StrandGroups,
	clump_ClumpGenerationMethod_Guides,
	clump_ClumpGenerationMethod_ExternalClumpStrands,
};

enum
{
	clump_ClumpEditMode_None,
	clump_ClumpEditMode_ClumpHairs,
	clump_ClumpEditMode_Clumps,
	clump_ClumpEditMode_Count,
};

#endif
